package gov.va.med.mhv.sm.admin.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.ArrayList;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ApiResponse;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.sm.admin.repository.TriageGroupRepository;
import gov.va.med.mhv.sm.admin.repository.TriageRelationRepository;
import gov.va.med.mhv.sm.admin.dto.ClinicDTO;
import gov.va.med.mhv.sm.admin.dto.PcmmProviderDTO;
import gov.va.med.mhv.sm.admin.dto.TeamDTO;
import gov.va.med.mhv.sm.admin.dto.TriageGroupDTO;
import gov.va.med.mhv.sm.admin.model.TriageGroup;
import gov.va.med.mhv.sm.admin.model.TriageRelation;
import gov.va.med.mhv.sm.admin.converter.TriageGroupConverter;
import gov.va.med.mhv.sm.admin.converter.TriageRelationConverter;

@Path("/")
@Service("triageGroupService")
@Component
@Api(value = "Triage Group Service")
public class TriageGroupServiceImpl { 

	@Autowired
	private TriageGroupConverter triageGroupConverter;
	
    @Autowired
    private TriageGroupRepository triageGroupRepository;
	

    @Autowired
    private TriageRelationRepository triageRelationRepository;
	
    
	private static final Log log = LogFactory.getLog(TriageGroupServiceImpl.class);

	@GET
	@Path("triagegroup/{name}")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get Triage Group by name",
//	        notes = "Get operation with Response and @Default value",
	        response = TriageGroupDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = TriageGroupDTO.class) 
	})			
	public TriageGroupDTO findTriageGroupName(@PathParam("name") String name) throws MHVException {
		
		TriageGroupDTO dto = null;
		try {
			if(name != null) {
				TriageGroup triageGroup = triageGroupRepository.findTriageGroupByName(name);
				if(triageGroup != null) {
					dto = TriageGroupConverter.convert(triageGroup);
				}
			}
			
		} catch (Exception e) {
			throw new MHVException(e);
		}

		return dto;
		
	}
	
	@GET
	@Path("findActiveTriageGroupByName/{name}")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get Active Triage Group by name",
//	        notes = "Get operation with Response and @Default value",
	        response = TriageGroupDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = TriageGroupDTO.class) 
	})			
	public TriageGroupDTO findActiveTriageGroupByName(@PathParam("name") String name) throws MHVException {
		
		TriageGroupDTO dto = null;
		try {
			if(name != null) {
				TriageGroup triageGroup = triageGroupRepository.findActiveTriageGroupByName(name);
				if(triageGroup != null) {
					dto = TriageGroupConverter.convert(triageGroup);
				}
			}
			
		} catch (Exception e) {
			throw new MHVException(e);
		}

		return dto;
		
	}
	
	@GET
	@Path("getTriageGroups")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get Active Triage Group by name",
//	        notes = "Get operation with Response and @Default value",
	        response = TriageGroupDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = TriageGroupDTO.class) 
	})			
	public List<TriageGroupDTO> getTriageGroups() throws MHVException {
		
		List<TriageGroupDTO>  dtoList = null;
		try {
			List<TriageGroup> triageGroupList = triageGroupRepository.getTriageGroups();
			if(triageGroupList != null && triageGroupList.size()>0) {
				dtoList = TriageGroupConverter.convertList(triageGroupList);
			}
			
		} catch (Exception e) {
			throw new MHVException(e);
		}

		return dtoList;
		
	}
	
	
	
	@GET
	@Path("getTriageGroupsByStation/{stationNumber}")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get TriageGroups For Station",
	        response = TriageGroupDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = TriageGroupDTO.class, responseContainer = "List") 
	})			
	public List<TriageGroupDTO> getTriageGroupsForStation(@PathParam("stationNumber") String stationNumber) throws MHVException {
		
		List<TriageGroupDTO> triageGroupDtoList = null;
		try 
		{
				List<TriageGroup> triageGroupList = triageGroupRepository.getTriageGroupsForStation(stationNumber);
				System.out.println("TG List==>"+triageGroupRepository.getTriageGroupsForStation("991"));
				if(triageGroupList != null) {
					triageGroupDtoList = TriageGroupConverter.convertList(triageGroupList);
				}
		
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return triageGroupDtoList;
	}
	
	@GET
	@Path("getPCMMProvidersByTriageGroup/{triageGroupId}")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get PCMM Providers By Triage Group",
	        response = PcmmProviderDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = PcmmProviderDTO.class, responseContainer = "List") 
	})			
	public List<PcmmProviderDTO> getPCMMProvidersByTriageGroup(@PathParam("triageGroupId") Long triageGroupId) throws MHVException {
		
		List<PcmmProviderDTO> pcmmProviderDtoList = null;
		try 
		{
				List<TriageRelation> triageRelationList = triageRelationRepository.getPCMMProvidersByTriageGroup(triageGroupId);
				System.out.println("PCMM Providers List==>"+triageRelationRepository.getPCMMProvidersByTriageGroup(triageGroupId));
				if(triageRelationList != null) {
					pcmmProviderDtoList = TriageRelationConverter.convertPCMMProvidersList(triageRelationList);
				}
		
		} catch (Exception e) {
			throw new MHVException(e);
		}

		return pcmmProviderDtoList;
	}
	
	@GET
	@Path("getClincsByTriageGroup/{triageGroupId}")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get Clinics By Triage Group",
	        response = PcmmProviderDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = ClinicDTO.class, responseContainer = "List") 
	})			
	public List<ClinicDTO> getClinicByTriageGroup(@PathParam("triageGroupId") Long triageGroupId) throws MHVException {
		
		List<ClinicDTO> clinicDtoList = null;
		try 
		{
				Collection<TriageRelation> triageRelationList = triageRelationRepository.getClinicsByTriageGroup(triageGroupId);
				System.out.println("Clinics List==>"+triageRelationRepository.getClinicsByTriageGroup(triageGroupId));
				if(triageRelationList != null) {
					clinicDtoList = TriageRelationConverter.convertClinicList(triageRelationList);
				}
		
		} catch (Exception e) {
			throw new MHVException(e);
		}

		return clinicDtoList;
	}
	
	@GET
	@Path("getTeamsByTriageGroup/{triageGroupId}")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get OERR Teams By Triage Group",
	        response = PcmmProviderDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = TeamDTO.class, responseContainer = "List") 
	})			
	public List<TeamDTO> getTeamsByTriageGroup(@PathParam("triageGroupId") Long triageGroupId) throws MHVException {
		
		List<TeamDTO> teamDtoList = null;
		try 
		{
				Collection<TriageRelation> triageRelationList = triageRelationRepository.getOERRTeamsByTriageGroup(triageGroupId);
				System.out.println("Clinics List==>"+triageRelationRepository.getOERRTeamsByTriageGroup(triageGroupId));
				if(triageRelationList != null) {
					teamDtoList = TriageRelationConverter.convertTeamList(triageRelationList);
				}
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return teamDtoList;
	}

	@GET
	@Path("getPatientsByTriageGroup/{triageGroupId}")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get TriageGroups For Patient",
	        response = TriageGroupDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = TriageGroupDTO.class, responseContainer = "List") 
	})			
	public List<TriageGroupDTO> getPatientsByTriageGroup(@PathParam("triageGroupId") Long triageGroupId) throws MHVException {
		
		List<TriageGroupDTO> triageGroupDtoList = null;
		
		try 
		{	if (triageGroupId != null) {
				List<TriageRelation> triageRelationPatientList = triageRelationRepository.getPatientsByTriageGroup(triageGroupId);
				if(triageRelationPatientList != null) {
					List<TriageGroup> triageGroupList = new ArrayList<TriageGroup>();
					for (TriageRelation triageRelation : triageRelationPatientList) {
						if(triageRelation != null) {
							triageGroupList.add(triageRelation.getTriageGroup());
						}
					}
					triageGroupDtoList = TriageGroupConverter.convertList(triageGroupList);
				}
			}
		
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return triageGroupDtoList;
	}

	@GET
	@Path("sayHello")	
	@Produces(MediaType.APPLICATION_JSON)
    @ApiOperation(
	        value = "Get Triage Group by name",
//	        notes = "Get operation with Response and @Default value",
	        response = TriageGroupDTO.class,
	        responseContainer = "List"
	    )
	@ApiResponses(value = {
	 @ApiResponse(code = 400, message = "Exception has Occured"),
	 @ApiResponse(code = 200, message = "Success", response = String.class) 
	})			
	public String sayHello(){
		
		return "Hello World";
		
	}
	
}
